---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：81-Spark Connectクライアント（JVM）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **TLS/SSL暗号化サポート**：コード上の明示的な確認が不十分
  2. **パフォーマンス要件の具体値**：定量的なベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/SparkConnectClient.scala` 50-76行目
- E-02: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/SparkSession.scala` 81-85行目
- E-03: `sql/connect/client/jvm/src/main/scala/org/apache/spark/sql/application/ConnectRepl.scala` 62-170行目
- E-04: `sql/connect/client/jvm/src/main/scala/org/apache/spark/sql/connect/client/AmmoniteClassFinder.scala` 34-46行目
- E-05: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/SparkConnectClient.scala` 183-299行目
- E-06: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/SparkConnectClient.scala` 201-279行目 (tryCompressPlan)
- E-07: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/ArtifactManager.scala`
- E-08: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/GrpcRetryHandler.scala`
- E-09: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/ResponseValidator.scala`
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 81行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gRPC経由でSparkクラスタに接続する | E-01 | ○ |
| C-02 | ビルダーパターンでクライアントを構築する | E-01 | ○ |
| C-03 | セッションIDはUUIDで自動生成される | E-01 (75行目) | ○ |
| C-04 | UserContextでユーザーIDを伝達する | E-01 (55行目) | ○ |
| C-05 | SparkSession.builder().client()でセッション構築 | E-02 | ○ |
| C-06 | Protobufプランをサーバーに送信する | E-05 | ○ |
| C-07 | Arrow形式で結果を受信する | E-02 (87行目 RootAllocator) | ○ |
| C-08 | Zstdによるプラン圧縮が行われる | E-06 | ○ |
| C-09 | 圧縮閾値超過時のみ圧縮が適用される | E-06 (259行目) | ○ |
| C-10 | ArtifactManagerでクラスファイルをアップロードする | E-05, E-07 | ○ |
| C-11 | execute前にアーティファクトを自動アップロードする | E-05 (291行目) | ○ |
| C-12 | Ammonite REPLでのインメモリクラス検出 | E-04 | ○ |
| C-13 | ConnectReplがREPLエントリーポイントとなる | E-03 | ○ |
| C-14 | GrpcRetryHandlerでリトライを制御する | E-08 | ○ |
| C-15 | ResponseValidatorでセッション有効性を検証する | E-09 | ○ |
| C-16 | プラン解析失敗時に圧縮を無効化してリトライする | E-06 (131-139行目) | ○ |
| C-17 | 接続文字列はsc://形式をサポートする | E-01 (SparkConnectClientParser) | ○ |
| C-18 | ExtendedCodeClassWrapperでOuterScopes登録 | E-03 (177-193行目) | ○ |
| C-19 | TLS/SSL暗号化をサポートする | **根拠なし** | △ |
| C-20 | gRPCチャネルを再利用して接続オーバーヘッドを削減 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TLS/SSL暗号化の具体的な設定と実装の確認
  - 候補：gRPCチャネルビルダーの設定コード / Spark Connectサーバーのセキュリティ設定ドキュメント
- パフォーマンス要件の定量的根拠
  - 候補：ベンチマーク結果 / Spark Connect設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張はソースコードから直接確認可能
- 1: 中リスク - セキュリティ関連の記述はサーバー側設定に依存するため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] SparkConnectClient.scalaのビルダーパターン実装を確認
- [ ] gRPC接続のセキュリティ設定（TLS/SSL）の実装有無を確認
- [ ] プラン圧縮のパフォーマンス効果を検証
- [ ] Ammonite REPL統合のクラスファイルアップロード動作を確認
